local player = ...
local pn = tonumber(player:sub(-1))

-- exit if disabled
if SL["P"..pn].ActiveModifiers.EarlyLate == "Disabled" then return end

local usetick = SL["P"..pn].ActiveModifiers.EarlyLate == "Simple"

local useitg = SL["P"..pn].ActiveModifiers.SimulateITGEnv

local threshold = SL["P"..pn].ActiveModifiers.EarlyLateThreshold == "FA+" and SL["P"..pn].ActiveModifiers.FAPlus or 0
if (useitg) and threshold == 0 then
    threshold = WF.ITGTimingWindows[WF.ITGJudgments.Fantastic]
elseif (not useitg) and threshold == 0.015 then
    -- this condition should not happen but might as well cover it here too
    threshold = 0
end

local text = LoadFont("_wendy small")..{
    Text = "",
    InitCommand = function(self)
        local reverse = GAMESTATE:GetPlayerState(player):GetPlayerOptions("ModsLevel_Preferred"):UsingReverse()
        self:zoom(0.25)
        self:y((reverse and 1 or -1) * 48)
    end,
    JudgmentMessageCommand = function(self, params)
        if params.Player ~= player then return end
        if params.TapNoteScore and (not params.HoldNoteScore) and params.TapNoteScore ~= "TapNoteScore_AvoidMine" and
        params.TapNoteScore ~= "TapNoteScore_HitMine" and params.TapNoteScore ~= "TapNoteScore_Miss" then
            if (threshold == 0 and params.TapNoteScore ~= "TapNoteScore_W1") or 
            (threshold > 0 and math.abs(params.TapNoteOffset) > threshold) then
                self:finishtweening()
                self:settext(params.Early and "EARLY" or "LATE")
                self:x((params.Early and -1 or 1) * 40)
                self:diffusealpha(1)
                self:sleep(0.5)
                self:diffusealpha(0)
            else
                self:finishtweening()
                self:diffusealpha(0)
            end
        end
    end
}

local quad = Def.Quad{
    InitCommand = function(self)
        local reverse = GAMESTATE:GetPlayerState(player):GetPlayerOptions("ModsLevel_Preferred"):UsingReverse()
        self:zoomto(20,4)
        self:y((reverse and 1 or -1) * 48)
        self:diffusealpha(0)
    end,
    JudgmentMessageCommand = function(self, params)
        if params.Player ~= player then return end
        if params.TapNoteScore and (not params.HoldNoteScore) and params.TapNoteScore ~= "TapNoteScore_AvoidMine" and
        params.TapNoteScore ~= "TapNoteScore_HitMine" and params.TapNoteScore ~= "TapNoteScore_Miss" then
            if ((not useitg) and params.TapNoteScore ~= "TapNoteScore_W1") or 
            (useitg and math.abs(params.TapNoteOffset) > threshold) then
                self:finishtweening()
                self:x((params.Early and -1 or 1) * 40)
                self:diffusealpha(1)
                self:sleep(0.5)
                self:diffusealpha(0)
            else
                self:finishtweening()
                self:diffusealpha(0)
            end
        end
    end
}

local af = Def.ActorFrame{
    OnCommand = function(self)
        self:xy(GetNotefieldX(player), _screen.cy)
    end
}

if not usetick then af[#af+1] = text else af[#af+1] = quad end

return af
